#!/system/bin/sh


HOSTS_FILE="/system/etc/hosts"
IP="127.0.1.1"


hname="localhost"


if [ -f /drd-conf/serial ] ; then
    hname="$(cat /drd-conf/serial | tr -d '\n')"
fi


if [ -f /drd-data/hostname ] ; then
    hname="$(cat /drd-data/hostname | tr -d '\n')"
fi


if [ "${hname}"x = ""x ] ; then
    echo "unable to get hostname"
    log -p e "/vendor/at-boot.d/001-set-hostname: unable to get hostname"
    exit 0
fi


hosts="$(cat ${HOSTS_FILE} | grep -v "^${IP}")"
hosts="${hosts}\n${IP}\t${hname}"


hostname "${hname}"
echo -e "${hosts}" > ${HOSTS_FILE}
log "/vendor/at-boot.d/001-set-hostname: set hostname to ${hname}"


exit 0
